# IAM Permissions Guide

This document provides comprehensive IAM permission requirements for deploying and operating the AWS IoT Wireless Device Bulk Management Solution.

## Table of Contents

- [Deployment Permissions](#deployment-permissions)
- [Runtime Permissions](#runtime-permissions)
- [User Permissions](#user-permissions)
- [AWS Managed Policies](#aws-managed-policies)

---

## Deployment Permissions

### Required AWS Services Permissions

To deploy this solution using AWS CDK, your IAM user or role needs permissions for the following AWS services:

#### CloudFormation
```json
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "cloudformation:CreateStack",
        "cloudformation:UpdateStack",
        "cloudformation:DeleteStack",
        "cloudformation:DescribeStacks",
        "cloudformation:DescribeStackEvents",
        "cloudformation:DescribeStackResources",
        "cloudformation:GetTemplate",
        "cloudformation:ValidateTemplate"
      ],
      "Resource": "*"
    }
  ]
}
```

#### S3 (for CDK assets and solution buckets)
```json
{
  "Effect": "Allow",
  "Action": [
    "s3:CreateBucket",
    "s3:DeleteBucket",
    "s3:PutBucketPolicy",
    "s3:PutBucketVersioning",
    "s3:PutBucketPublicAccessBlock",
    "s3:PutBucketNotification",
    "s3:PutLifecycleConfiguration",
    "s3:PutEncryptionConfiguration",
    "s3:GetBucketLocation",
    "s3:ListBucket",
    "s3:GetObject",
    "s3:PutObject",
    "s3:DeleteObject"
  ],
  "Resource": [
    "arn:aws:s3:::cdk-*",
    "arn:aws:s3:::aws-iot-wireless-*"
  ]
}
```

#### Lambda
```json
{
  "Effect": "Allow",
  "Action": [
    "lambda:CreateFunction",
    "lambda:DeleteFunction",
    "lambda:UpdateFunctionCode",
    "lambda:UpdateFunctionConfiguration",
    "lambda:GetFunction",
    "lambda:GetFunctionConfiguration",
    "lambda:AddPermission",
    "lambda:RemovePermission",
    "lambda:PublishLayerVersion",
    "lambda:DeleteLayerVersion",
    "lambda:GetLayerVersion",
    "lambda:TagResource",
    "lambda:UntagResource"
  ],
  "Resource": "*"
}
```

#### IAM (for Lambda execution roles)
```json
{
  "Effect": "Allow",
  "Action": [
    "iam:CreateRole",
    "iam:DeleteRole",
    "iam:AttachRolePolicy",
    "iam:DetachRolePolicy",
    "iam:PutRolePolicy",
    "iam:DeleteRolePolicy",
    "iam:GetRole",
    "iam:GetRolePolicy",
    "iam:PassRole",
    "iam:TagRole",
    "iam:UntagRole"
  ],
  "Resource": "*"
}
```

#### Step Functions
```json
{
  "Effect": "Allow",
  "Action": [
    "states:CreateStateMachine",
    "states:DeleteStateMachine",
    "states:UpdateStateMachine",
    "states:DescribeStateMachine",
    "states:TagResource",
    "states:UntagResource"
  ],
  "Resource": "*"
}
```

#### RDS (Aurora Serverless v2)
```json
{
  "Effect": "Allow",
  "Action": [
    "rds:CreateDBCluster",
    "rds:DeleteDBCluster",
    "rds:ModifyDBCluster",
    "rds:DescribeDBClusters",
    "rds:CreateDBInstance",
    "rds:DeleteDBInstance",
    "rds:ModifyDBInstance",
    "rds:DescribeDBInstances",
    "rds:AddTagsToResource",
    "rds:RemoveTagsFromResource"
  ],
  "Resource": "*"
}
```

#### EC2 (for VPC resources)
```json
{
  "Effect": "Allow",
  "Action": [
    "ec2:CreateVpc",
    "ec2:DeleteVpc",
    "ec2:DescribeVpcs",
    "ec2:CreateSubnet",
    "ec2:DeleteSubnet",
    "ec2:DescribeSubnets",
    "ec2:CreateSecurityGroup",
    "ec2:DeleteSecurityGroup",
    "ec2:DescribeSecurityGroups",
    "ec2:AuthorizeSecurityGroupIngress",
    "ec2:AuthorizeSecurityGroupEgress",
    "ec2:RevokeSecurityGroupIngress",
    "ec2:RevokeSecurityGroupEgress",
    "ec2:CreateRouteTable",
    "ec2:DeleteRouteTable",
    "ec2:DescribeRouteTables",
    "ec2:AssociateRouteTable",
    "ec2:DisassociateRouteTable",
    "ec2:CreateTags",
    "ec2:DeleteTags"
  ],
  "Resource": "*"
}
```

#### Secrets Manager (for database credentials)
```json
{
  "Effect": "Allow",
  "Action": [
    "secretsmanager:CreateSecret",
    "secretsmanager:DeleteSecret",
    "secretsmanager:DescribeSecret",
    "secretsmanager:GetSecretValue",
    "secretsmanager:PutSecretValue",
    "secretsmanager:TagResource",
    "secretsmanager:UntagResource"
  ],
  "Resource": "*"
}
```

#### CloudWatch (for logs and metrics)
```json
{
  "Effect": "Allow",
  "Action": [
    "logs:CreateLogGroup",
    "logs:DeleteLogGroup",
    "logs:DescribeLogGroups",
    "logs:PutRetentionPolicy",
    "logs:TagLogGroup",
    "logs:UntagLogGroup",
    "cloudwatch:PutDashboard",
    "cloudwatch:DeleteDashboards",
    "cloudwatch:GetDashboard"
  ],
  "Resource": "*"
}
```

#### EventBridge (for S3 event triggers)
```json
{
  "Effect": "Allow",
  "Action": [
    "events:PutRule",
    "events:DeleteRule",
    "events:DescribeRule",
    "events:PutTargets",
    "events:RemoveTargets",
    "events:TagResource",
    "events:UntagResource"
  ],
  "Resource": "*"
}
```

#### SQS (if using SQS notifications)
```json
{
  "Effect": "Allow",
  "Action": [
    "sqs:CreateQueue",
    "sqs:DeleteQueue",
    "sqs:GetQueueAttributes",
    "sqs:SetQueueAttributes",
    "sqs:TagQueue",
    "sqs:UntagQueue"
  ],
  "Resource": "*"
}
```

#### SNS (if using SNS notifications)
```json
{
  "Effect": "Allow",
  "Action": [
    "sns:CreateTopic",
    "sns:DeleteTopic",
    "sns:GetTopicAttributes",
    "sns:SetTopicAttributes",
    "sns:TagResource",
    "sns:UntagResource"
  ],
  "Resource": "*"
}
```

---

## Runtime Permissions

Once deployed, the solution's Lambda functions require these permissions (automatically granted by CDK):

### IoT Wireless API Operations
```json
{
  "Effect": "Allow",
  "Action": [
    "iotwireless:CreateWirelessDevice",
    "iotwireless:UpdateWirelessDevice",
    "iotwireless:GetWirelessDevice",
    "iotwireless:ListWirelessDevices"
  ],
  "Resource": "*"
}
```

### S3 Access (for input files and reports)
```json
{
  "Effect": "Allow",
  "Action": [
    "s3:GetObject",
    "s3:PutObject",
    "s3:DeleteObject",
    "s3:ListBucket"
  ],
  "Resource": [
    "arn:aws:s3:::aws-iot-wireless-input-*",
    "arn:aws:s3:::aws-iot-wireless-input-*/*",
    "arn:aws:s3:::aws-iot-wireless-reports-*",
    "arn:aws:s3:::aws-iot-wireless-reports-*/*"
  ]
}
```

### RDS Data API (for database access)
```json
{
  "Effect": "Allow",
  "Action": [
    "rds-data:ExecuteStatement",
    "rds-data:BatchExecuteStatement",
    "rds-data:BeginTransaction",
    "rds-data:CommitTransaction",
    "rds-data:RollbackTransaction"
  ],
  "Resource": "arn:aws:rds:*:*:cluster:*"
}
```

### CloudWatch Metrics
```json
{
  "Effect": "Allow",
  "Action": [
    "cloudwatch:PutMetricData"
  ],
  "Resource": "*"
}
```

### Secrets Manager (for database credentials)
```json
{
  "Effect": "Allow",
  "Action": [
    "secretsmanager:GetSecretValue"
  ],
  "Resource": "arn:aws:secretsmanager:*:*:secret:*"
}
```

---

## User Permissions

### For Uploading Device Files

Users who upload device JSON files to S3 need:

```json
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "s3:PutObject",
        "s3:GetObject",
        "s3:ListBucket"
      ],
      "Resource": [
        "arn:aws:s3:::aws-iot-wireless-input-*",
        "arn:aws:s3:::aws-iot-wireless-input-*/*"
      ]
    },
    {
      "Effect": "Allow",
      "Action": [
        "s3:GetObject",
        "s3:ListBucket"
      ],
      "Resource": [
        "arn:aws:s3:::aws-iot-wireless-reports-*",
        "arn:aws:s3:::aws-iot-wireless-reports-*/*"
      ]
    }
  ]
}
```

### For Monitoring and Troubleshooting

Users who need to monitor batch processing and troubleshoot issues need:

```json
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "logs:DescribeLogGroups",
        "logs:DescribeLogStreams",
        "logs:GetLogEvents",
        "logs:FilterLogEvents"
      ],
      "Resource": [
        "arn:aws:logs:*:*:log-group:/aws/lambda/*",
        "arn:aws:logs:*:*:log-group:/aws/vendedlogs/states/*"
      ]
    },
    {
      "Effect": "Allow",
      "Action": [
        "states:ListExecutions",
        "states:DescribeExecution",
        "states:GetExecutionHistory",
        "states:DescribeStateMachine",
        "states:ListStateMachines"
      ],
      "Resource": [
        "arn:aws:states:*:*:stateMachine:AWSIoTWirelessDeviceBulkManagementStateMachine",
        "arn:aws:states:*:*:execution:AWSIoTWirelessDeviceBulkManagementStateMachine:*"
      ]
    },
    {
      "Effect": "Allow",
      "Action": [
        "cloudwatch:GetDashboard",
        "cloudwatch:ListDashboards",
        "cloudwatch:GetMetricData",
        "cloudwatch:GetMetricStatistics",
        "cloudwatch:ListMetrics"
      ],
      "Resource": "*"
    },
    {
      "Effect": "Allow",
      "Action": [
        "lambda:GetFunction",
        "lambda:GetFunctionConfiguration",
        "lambda:ListFunctions"
      ],
      "Resource": "arn:aws:lambda:*:*:function:*"
    }
  ]
}
```

**What these permissions allow:**
- **CloudWatch Logs**: View Lambda function logs and Step Functions execution logs for troubleshooting
- **Step Functions**: View execution history, status, and detailed execution steps
- **CloudWatch Metrics**: Access dashboards and view custom metrics for monitoring
- **Lambda**: View function configurations and invocation details

### Complete User Policy (Upload + Monitor)

For users who need both upload and monitoring capabilities:

```json
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "S3FileUploadAndReports",
      "Effect": "Allow",
      "Action": [
        "s3:PutObject",
        "s3:GetObject",
        "s3:ListBucket"
      ],
      "Resource": [
        "arn:aws:s3:::aws-iot-wireless-input-*",
        "arn:aws:s3:::aws-iot-wireless-input-*/*",
        "arn:aws:s3:::aws-iot-wireless-reports-*",
        "arn:aws:s3:::aws-iot-wireless-reports-*/*"
      ]
    },
    {
      "Sid": "CloudWatchLogsRead",
      "Effect": "Allow",
      "Action": [
        "logs:DescribeLogGroups",
        "logs:DescribeLogStreams",
        "logs:GetLogEvents",
        "logs:FilterLogEvents"
      ],
      "Resource": [
        "arn:aws:logs:*:*:log-group:/aws/lambda/*",
        "arn:aws:logs:*:*:log-group:/aws/vendedlogs/states/*"
      ]
    },
    {
      "Sid": "StepFunctionsRead",
      "Effect": "Allow",
      "Action": [
        "states:ListExecutions",
        "states:DescribeExecution",
        "states:GetExecutionHistory",
        "states:DescribeStateMachine",
        "states:ListStateMachines"
      ],
      "Resource": [
        "arn:aws:states:*:*:stateMachine:AWSIoTWirelessDeviceBulkManagementStateMachine",
        "arn:aws:states:*:*:execution:AWSIoTWirelessDeviceBulkManagementStateMachine:*"
      ]
    },
    {
      "Sid": "CloudWatchMetricsRead",
      "Effect": "Allow",
      "Action": [
        "cloudwatch:GetDashboard",
        "cloudwatch:ListDashboards",
        "cloudwatch:GetMetricData",
        "cloudwatch:GetMetricStatistics",
        "cloudwatch:ListMetrics"
      ],
      "Resource": "*"
    },
    {
      "Sid": "LambdaRead",
      "Effect": "Allow",
      "Action": [
        "lambda:GetFunction",
        "lambda:GetFunctionConfiguration",
        "lambda:ListFunctions"
      ],
      "Resource": "arn:aws:lambda:*:*:function:*"
    }
  ]
}
```

---

## AWS Managed Policies

Instead of custom policies, you can use these AWS managed policies for deployment:

- **`AdministratorAccess`** - Full access to all AWS services (not recommended for production)
- **`PowerUserAccess`** - Access to most services except IAM user management

**Recommendation:** For production deployments, create a custom policy with only the required permissions listed above to follow the principle of least privilege.

---

## Permission Summary

| Role | Required Permissions | Use Case |
|------|---------------------|----------|
| **Deployer** | CloudFormation, S3, Lambda, IAM, Step Functions, RDS, EC2, Secrets Manager, CloudWatch, EventBridge, SQS/SNS | Deploy and manage the CDK stack |
| **Lambda Functions** | IoT Wireless, S3, RDS Data API, CloudWatch, Secrets Manager | Automatically granted by CDK during deployment |
| **File Uploader** | S3 (input bucket write, reports bucket read) | Upload device JSON files and view reports |
| **Monitor/Operator** | CloudWatch Logs, Step Functions, CloudWatch Metrics, Lambda (read-only) | Monitor processing and troubleshoot issues |
| **Full User** | S3 + CloudWatch + Step Functions + Lambda (read-only) | Upload files and monitor processing |

---

## Security Best Practices

1. **Principle of Least Privilege**: Grant only the minimum permissions required for each role
2. **Use IAM Roles**: Prefer IAM roles over IAM users for AWS service access
3. **Enable MFA**: Require multi-factor authentication for sensitive operations
4. **Regular Audits**: Periodically review and audit IAM permissions
5. **Resource Tagging**: Use tags for cost allocation and access control
6. **CloudTrail**: Enable AWS CloudTrail for API call auditing
7. **Separate Environments**: Use different AWS accounts for dev/staging/production

---

## Troubleshooting Permission Issues

### Common Permission Errors

**Error**: `User is not authorized to perform: cloudformation:CreateStack`
- **Solution**: Add CloudFormation permissions to your IAM user/role

**Error**: `Access Denied` when uploading to S3
- **Solution**: Verify S3 bucket permissions and ensure bucket names match the pattern `aws-iot-wireless-input-*`

**Error**: `Cannot assume role` during Lambda execution
- **Solution**: Check that the Lambda execution role has the correct trust policy

**Error**: `RDS Data API access denied`
- **Solution**: Ensure Lambda has `rds-data:ExecuteStatement` permission and access to the database secret

### Verifying Permissions

Use AWS CLI to test permissions:

```bash
# Test S3 access
aws s3 ls s3://aws-iot-wireless-input-ACCOUNT-REGION/

# Test Lambda function access
aws lambda get-function --function-name YourFunctionName

# Test Step Functions access
aws stepfunctions list-state-machines

# Test CloudWatch Logs access
aws logs describe-log-groups --log-group-name-prefix /aws/lambda/
```

---

For more information, see the [main README](README.md).
